<?php

namespace App\Jobs;

use App\Http\Helpers\BasicMailer;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessMail implements ShouldQueue
{
  use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

  protected $data;

  /**
   * Create a new job instance.
   *
   * @return void
   */
  public function __construct($mailData)
  {
    $this->data = $mailData;
  }

  /**
   * Execute the job.
   *
   * @return void
   */
  public function handle()
  {
    BasicMailer::sendMail($this->data);
  }
}
