<header class="header-area header_v1" data-aos="fade-down">
  <!-- Start mobile menu -->
  <div class="mobile-menu">
    <div class="container">
      <div class="mobile-menu-wrapper"></div>
    </div>
  </div>
  <!-- End mobile menu -->

  <div class="main-responsive-nav">
    <div class="container">
      <!-- Mobile Logo -->
      <?php if(!empty($websiteInfo->logo)): ?>
        <div class="logo">
          <a href="<?php echo e(route('index')); ?>" target="_self" title="<?php echo e(__('Logo')); ?>">
            <img class="lazyload" data-src="<?php echo e(asset('assets/img/' . $websiteInfo->logo)); ?>" alt="<?php echo e(__('Logo')); ?>">
          </a>
        </div>
      <?php endif; ?>
      <!-- Menu toggle button -->
      <button class="menu-toggler" type="button">
        <span></span>
        <span></span>
        <span></span>
      </button>
    </div>
  </div>

  <div class="main-navbar">
    <div class="header-bottom">
      <div class="container-fluid px-xl-5">
        <nav class="navbar navbar-expand-lg">
          <!-- Logo -->
          <?php if(!empty($websiteInfo->logo)): ?>
            <a class="navbar-brand" href="<?php echo e(route('index')); ?>" target="_self" title="<?php echo e(__('Logo')); ?>">
              <img class="lazyload" data-src="<?php echo e(asset('assets/img/' . $websiteInfo->logo)); ?>"
                alt="<?php echo e(__('Logo')); ?>">
            </a>
          <?php endif; ?>
          <!-- Navigation items -->
          <div class="collapse navbar-collapse">
            <ul id="mainMenu" class="navbar-nav mobile-item mx-auto">
              <?php $menuDatas = json_decode($menuInfos); ?>
              <?php $__currentLoopData = $menuDatas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $href = get_href($menuData); ?>
                <?php if(!property_exists($menuData, 'children')): ?>
                  <li class="nav-item">
                    <a class="nav-link <?php echo e(url()->current() == $href ? 'active' : ''); ?>"
                      href="<?php echo e($href); ?>"><?php echo e($menuData->text); ?></a>
                  </li>
                <?php else: ?>
                  <li class="nav-item">
                    <a class="nav-link toggle <?php echo e(url()->current() == $href ? 'active' : ''); ?>"
                      href="<?php echo e($href); ?>"><?php echo e($menuData->text); ?><i class="fal fa-plus"></i></a>
                    <ul class="menu-dropdown">
                      <?php $childMenuDatas = $menuData->children; ?>

                      <?php $__currentLoopData = $childMenuDatas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childMenuData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $child_href = get_href($childMenuData); ?>
                        <li class="nav-item">
                          <a class="nav-link <?php echo e(url()->current() == $child_href ? 'active' : ''); ?>"
                            href="<?php echo e($child_href); ?>"><?php echo e($childMenuData->text); ?></a>
                        </li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                  </li>
                <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
          <div class="more-option mobile-item">
            <?php if($basicInfo->is_language == 1): ?>
              <div class="item">
                <div class="language">
                  <form action="<?php echo e(route('change_language')); ?>" method="GET">
                    <select class="niceselect" name="lang_code" onchange="this.form.submit()">
                      <?php $__currentLoopData = $allLanguageInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $languageInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($languageInfo->code); ?>" <?php if($languageInfo->code == $currentLanguageInfo->code): echo 'selected'; endif; ?>>
                          <?php echo e($languageInfo->name); ?>

                        </option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </form>
                </div>
              </div>
            <?php endif; ?>
            <div class="item">
              <a href="#searchBox" class="btn-search btn-icon rounded-1" target="_self" aria-label="Search Form"
                title="Search Form" data-effect="mfp-zoom-in">
                <i class="far fa-search"></i>
              </a>

              <div id="searchBox" class="search-box mx-auto mfp-with-anim mfp-hide mt-30">
                <form action="<?php echo e(route('services')); ?>" method="GET">
                  <div class="input-inline p-1 border radius-sm">
                    <input class="form-control border-0 color-light" placeholder="<?php echo e(__('Search Service') . '...'); ?>"
                      type="text" name="keyword">
                    <button class="btn-icon radius-sm" type="submit" aria-label="button">
                      <i class="far fa-search"></i>
                    </button>
                  </div>
                </form>
              </div>
            </div>
            <div class="item">
              <div class="dropdown">
                <button class="btn btn-sm btn-outline rounded-1 dropdown-toggle" type="button"
                  data-bs-toggle="dropdown" aria-expanded="false">
                  <span><?php echo e(__('Seller')); ?></span>
                </button>
                <ul class="dropdown-menu">
                  <?php if(auth()->guard('seller')->guest()): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('seller.login')); ?>"><?php echo e(__('Login')); ?></a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('seller.signup')); ?>"><?php echo e(__('Signup')); ?></a></li>
                  <?php endif; ?>
                  <?php if(auth()->guard('seller')->check()): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('seller.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('seller.logout')); ?>"><?php echo e(__('Logout')); ?></a></li>
                  <?php endif; ?>
                </ul>
              </div>
            </div>
            <div class="item">
              <div class="dropdown">
                <button class="btn btn-sm btn-primary rounded-1 dropdown-toggle" type="button"
                  data-bs-toggle="dropdown" aria-expanded="false">
                  <span><?php echo e(__('Customer')); ?></span>
                </button>
                <ul class="dropdown-menu">
                  <?php if(auth()->guard('web')->guest()): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('user.login')); ?>"><?php echo e(__('Login')); ?></a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('user.signup')); ?>"><?php echo e(__('Signup')); ?></a></li>
                  <?php endif; ?>
                  <?php if(auth()->guard('web')->check()): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('user.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('user.logout')); ?>"><?php echo e(__('Logout')); ?></a></li>
                  <?php endif; ?>
                </ul>
              </div>
            </div>
          </div>
        </nav>
      </div>
    </div>
  </div>

  <!-- Category menu -->
  <?php if(count($menu_categories) > 0): ?>
    <div class="categories-menu" dir="ltr">
      <div class="container-fluid px-xl-5">
        <nav class="categories-menu-nav">
          <div class="arrows left-arrow">
            <i class="fal fa-chevron-left"></i>
          </div>
          <ul class="categories list-unstyled">
            <?php $__currentLoopData = $menu_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php
                $subcategories = $category->subcategory()->get();
              ?>
              <?php if(count($subcategories) > 0): ?>
                <li class="sub-menu-item">
                  <a href="<?php echo e(route('services', ['category' => $category->slug])); ?>"><?php echo e($category->name); ?></a>
                  <div class="sub-menu menu-panel">
                    <ul class="menu-list list-unstyled">
                      <li class="menu-item">
                        <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <a
                            href="<?php echo e(route('services', ['subcategory' => $subcategory->slug])); ?>"><?php echo e($subcategory->name); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </li>
                    </ul>
                  </div>
                </li>
              <?php else: ?>
                <li class="sub-menu-item">
                  <a href="<?php echo e(route('services', ['category' => $category->slug])); ?>"><?php echo e($category->name); ?></a>
                </li>
              <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
          <div class="arrows right-arrow active">
            <i class="fal fa-chevron-right"></i>
          </div>
        </nav>
      </div>
    </div>
  <?php endif; ?>
</header>
<?php /**PATH /Users/samiulalimpratik/Sites/multigig/resources/views/frontend/partials/header/header-nav-v1.blade.php ENDPATH**/ ?>