<!DOCTYPE html>
<html lang="<?php echo e($currentLanguageInfo->code); ?>" <?php if($currentLanguageInfo->direction == 1): ?> dir="rtl" <?php endif; ?>>

<head>
  
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="keywords" content="<?php echo $__env->yieldContent('metaKeywords'); ?>">
  <meta name="description" content="<?php echo $__env->yieldContent('metaDescription'); ?>">

  
  <title><?php echo $__env->yieldContent('pageHeading'); ?> <?php echo e('| ' . $websiteInfo->website_title); ?></title>
  <!-- Favicon -->
  <link rel="shortcut icon" href="<?php echo e(asset('assets/img/' . $websiteInfo->favicon)); ?>" type="image/x-icon">
  
  <?php if($basicInfo->theme_version == 1): ?>
    <?php if ($__env->exists('frontend.partials.styles.style-v1')) echo $__env->make('frontend.partials.styles.style-v1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php elseif($basicInfo->theme_version == 2): ?>
    <?php if ($__env->exists('frontend.partials.styles.style-v2')) echo $__env->make('frontend.partials.styles.style-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php elseif($basicInfo->theme_version == 3): ?>
    <?php if ($__env->exists('frontend.partials.styles.style-v3')) echo $__env->make('frontend.partials.styles.style-v3', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>
  <style>
    :root {
      --color-primary: #<?php echo e($basicInfo->primary_color); ?>;
      --color-primary-rgb: <?php echo e(hexToRgb($basicInfo->primary_color)); ?>;
    }

    .breadcrumbs-area::after{
      background-color: #<?php echo e($basicInfo->breadcrumb_overlay_color); ?>;
      opacity: <?php echo e($basicInfo->breadcrumb_overlay_opacity); ?>;
    }
  </style>
</head>

<body>

  <!-- Preloader start -->
  <div id="preLoader">
    <div class="loader"></div>
  </div>
  <!-- Preloader end -->
  <div class="request-loader">
    <div class="loader-inner">
      <span class="loader"></span>
    </div>
  </div>

  <div class="main-wrapper">

    <!-- Header-area start -->
    <?php if($basicInfo->theme_version == 1): ?>
      <?php if ($__env->exists('frontend.partials.header.header-nav-v1')) echo $__env->make('frontend.partials.header.header-nav-v1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($basicInfo->theme_version == 2): ?>
      <?php if ($__env->exists('frontend.partials.header.header-nav-v2')) echo $__env->make('frontend.partials.header.header-nav-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif($basicInfo->theme_version == 3): ?>
      <?php if ($__env->exists('frontend.partials.header.header-nav-v3')) echo $__env->make('frontend.partials.header.header-nav-v3', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <!-- Header-area end -->
    <?php echo $__env->yieldContent('content'); ?>
  </div>

  
  <?php if ($__env->exists('frontend.partials.popups')) echo $__env->make('frontend.partials.popups', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <?php if(!is_null($cookieAlertInfo) && $cookieAlertInfo->cookie_alert_status == 1): ?>
    <?php if ($__env->exists('cookie-consent::index')) echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>
  
  <?php if($basicInfo->whatsapp_status == 1): ?>
    <div class="whatsapp-btn"></div>
  <?php endif; ?>

  <!-- Footer-area start -->
  <?php if($basicInfo->theme_version == 1): ?>
    <?php if ($__env->exists('frontend.partials.footer.footer-v1')) echo $__env->make('frontend.partials.footer.footer-v1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php elseif($basicInfo->theme_version == 2): ?>
    <?php if ($__env->exists('frontend.partials.footer.footer-v2')) echo $__env->make('frontend.partials.footer.footer-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php elseif($basicInfo->theme_version == 3): ?>
    <?php if ($__env->exists('frontend.partials.footer.footer-v3')) echo $__env->make('frontend.partials.footer.footer-v3', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>
  <!-- Footer-area end-->

  <!-- Jquery JS -->
  <?php if($basicInfo->theme_version == 1): ?>
    <?php if ($__env->exists('frontend.partials.scripts.script-v1')) echo $__env->make('frontend.partials.scripts.script-v1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php elseif($basicInfo->theme_version == 2): ?>
    <?php if ($__env->exists('frontend.partials.scripts.script-v2')) echo $__env->make('frontend.partials.scripts.script-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php elseif($basicInfo->theme_version == 3): ?>
    <?php if ($__env->exists('frontend.partials.scripts.script-v3')) echo $__env->make('frontend.partials.scripts.script-v3', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>
  
</body>

</html>
<?php /**PATH /Users/samiulalimpratik/Sites/multigig/resources/views/frontend/layout.blade.php ENDPATH**/ ?>